package org.pgusb.usbDllAdapter;

/* equivalencia entre tipos de datos en windows
 * en los tipos que se van a utilizar en la interfaz
 * http://msdn2.microsoft.com/en-us/library/aa383751.aspx
 * 
 * Windows			Tipo C              Longitud (bytes)       Jnative   claseNuestra
 * void				void					
 * DWORD			unsigned long           4					LONG (o int)			
 * PCHAR			char*					4							  PCHAR 	
 * HANDLE			void*					4					HANDLE
 * PVOID			void*					4					
 * PDWORD			unsigned long* 			4				
 * BOOL				int					    4					LONG
 */

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.HeapMemoryBlock;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

public class UsbDllAdapter {
	public static final String DLL_NAME = "mpusbapi.dll";
	
	//caches de las funciones de la dll
	private static JNative f_MPUSBGetDLLVersion;
    private static JNative f_MPUSBGetDeviceCount;
    private static JNative f_MPUSBOpen;    
    private static JNative f_MPUSBRead;
    private static JNative f_MPUSBWrite;
    private static JNative f_MPUSBReadInt;
    private static JNative f_MPUSBClose;
    
    /*
     * wrapper de la funcion de la dll:
     * DWORD MPUSBGetDLLVersion(void);
     */
    
    public static int MPUSBGetDLLVersion() throws NativeException, IllegalAccessException {
		if(f_MPUSBGetDLLVersion == null) {
            //seteo la funcion a invocar
    		f_MPUSBGetDLLVersion = new JNative(DLL_NAME, "MPUSBGetDLLVersion");
            //seteo tipo de retorno (la dll devuelve un DWORD) 
    		f_MPUSBGetDLLVersion.setRetVal(Type.LONG);
    	}	
    	//invoco la funcion
    	f_MPUSBGetDLLVersion.invoke();
    	//retorno un int con el valor retornado por la funcion invocada
        return new Integer(f_MPUSBGetDLLVersion.getRetVal()).intValue();
    }  	
    	
    /*
     * wrapper de la funcion de la dll:
     * DWORD MPUSBGetDeviceCount(PCHAR pVID_PID);
     */
    
    public static int MPUSBGetDeviceCount(String vid_pid) throws NativeException, IllegalAccessException {
    	if(f_MPUSBGetDeviceCount == null) {
    		//seteo la funcion a invocar
    		f_MPUSBGetDeviceCount = new JNative(DLL_NAME, "MPUSBGetDeviceCount");
    		//seteo tipo de retorno (la dll devuelve un DWORD) 
    		f_MPUSBGetDeviceCount.setRetVal(Type.LONG);
    	}	
    	//creo el parametro a pasar
    	Pointer p_vid_pid = new	Pointer(MemoryBlockFactory.createMemoryBlock(vid_pid.length()+1));
    	p_vid_pid.setStringAt(0,vid_pid);
    	f_MPUSBGetDeviceCount.setParameter(0, p_vid_pid);
    	//invoco la funcion
    	f_MPUSBGetDeviceCount.invoke();
    	//retorno un int con el valor retornado por la funcion invocada
        int ret = new Integer(f_MPUSBGetDeviceCount.getRetVal()).intValue();
    	p_vid_pid.dispose(); //hago dispose del puntero
        return ret;
    }  	
    
    /*
     * wrapper de la funcion de la dll:
     * HANDLE MPUSBOpen(DWORD instance,    // Input
                 PCHAR pVID_PID,    // Input
                 PCHAR pEP,         // Input
                 DWORD dwDir,       // Input
                 DWORD dwReserved); // Input <Future Use>
     */
    
    public static int MPUSBOpen(int instance, String vid_pid, String ep, int dir, int reserved) throws NativeException, IllegalAccessException {
    	//creo el parametro a pasar
    	Pointer p_vid_pid = new	Pointer(MemoryBlockFactory.createMemoryBlock(vid_pid.length()+1));
    	p_vid_pid.setStringAt(0,vid_pid);
    	if(f_MPUSBOpen == null) {
    		//seteo la funcion a invocar
    		f_MPUSBOpen = new JNative(DLL_NAME, "MPUSBOpen");
    		//seteo tipo de retorno (la dll devuelve un DWORD) 
    		f_MPUSBOpen.setRetVal(Type.INT);
    	}	
    	//cargo parametros en la funcion
    	f_MPUSBOpen.setParameter(0, Type.INT, "" + instance);
    	f_MPUSBOpen.setParameter(1, p_vid_pid);
    	Pointer p_EP = null;
    	if (ep!=null){
    		p_EP = new	Pointer(MemoryBlockFactory.createMemoryBlock(ep.length()+1));
        	p_EP.setStringAt(0,ep);
        	f_MPUSBOpen.setParameter(2,p_EP);
    	}
    	else {
    		f_MPUSBOpen.setParameter(2, NullPointer.NULL);
    	}
    	f_MPUSBOpen.setParameter(3, Type.INT, "" +dir);
    	f_MPUSBOpen.setParameter(4, Type.INT, "" +reserved);
    	//invoco la funcion
    	f_MPUSBOpen.invoke();
    	int ret=Integer.parseInt(f_MPUSBOpen.getRetVal()); 
    	p_EP.dispose();// dispose del pointer p_EP
        return ret;
    }
    
    /*
     * wrapper de la funcion de la dll:
     * DWORD MPUSBRead(HANDLE handle,              // Input
                PVOID pData,                // Output
                DWORD dwLen,                // Input
                PDWORD pLength,             // Output
                DWORD dwMilliseconds);      // Input
     */
    
public static ReadBytes MPUSBRead(int handle, int len , int milliseconds) throws NativeException, IllegalAccessException {
    	Pointer pData = new	Pointer(new HeapMemoryBlock(len));
		//Pointer pData = new	Pointer(MemoryBlockFactory.createMemoryBlock(len));
    	LONG pLength = new LONG(40);
    	if(f_MPUSBRead == null) {
    		//seteo la funcion a invocar
        	f_MPUSBRead = new JNative(DLL_NAME, "MPUSBRead");
        	//seteo tipo de retorno (la dll devuelve un DWORD) 
    		f_MPUSBRead.setRetVal(Type.INT);
    	}	
    	//seteo los parametros de la funcion
    	f_MPUSBRead.setParameter(0, Type.INT, "" + handle);
    	f_MPUSBRead.setParameter(1, pData);
    	f_MPUSBRead.setParameter(2, Type.INT, "" + len);
    	f_MPUSBRead.setParameter(3, pLength.createPointer());
    	f_MPUSBRead.setParameter(4, Type.INT, "" +milliseconds);
    	//invoco la funcion
    	f_MPUSBRead.invoke();
    	byte[] readBytes = pData.getMemory();
    	pData.dispose();
    	ReadBytes ret=new ReadBytes(readBytes,
    					pLength.getValue(),
    					Integer.parseInt(f_MPUSBRead.getRetVal())); 
    	return ret;
    }

	/*
	 * wrapper de la funcion de la dll:
	 * DWORD MPUSBWrite(HANDLE handle,             // Input
	                 PVOID pData,               // Input
	                 DWORD dwLen,               // Input
	                 PDWORD pLength,            // Output
	                 DWORD dwMilliseconds);     // Input
	
	 */
	public static WriteBytes MPUSBWrite(int handle, byte[] data , int len , int milliseconds) throws NativeException, IllegalAccessException {
		
		Pointer pData = new	Pointer(MemoryBlockFactory.createMemoryBlock(len));
		pData.setMemory(data);
		LONG pLength = new LONG(0);
		if(f_MPUSBWrite == null) {
			//seteo la funcion a invocar
	        f_MPUSBWrite = new JNative(DLL_NAME, "MPUSBWrite");
	    	//seteo tipo de retorno (la dll devuelve un DWORD) 
	    	f_MPUSBWrite.setRetVal(Type.INT);
		}	
		//seteo los parametros
		f_MPUSBWrite.setParameter(0, Type.INT, "" + handle);
		f_MPUSBWrite.setParameter(1, pData);
		f_MPUSBWrite.setParameter(2,  Type.INT, "" +len);
		f_MPUSBWrite.setParameter(3, pLength.createPointer());
		f_MPUSBWrite.setParameter(4,  Type.INT, "" +milliseconds);
		//invoco la funcion
		f_MPUSBWrite.invoke();
		WriteBytes ret=new WriteBytes(pLength.getValue(),
						Integer.parseInt(f_MPUSBWrite.getRetVal())); 
		pData.dispose(); //hago dispose de pData
		return ret;
	}

	//TODO testear esta funcion
	/*
	 * wrapper de la funcion de la dll:
	 * DWORD MPUSBReadInt(HANDLE handle,           // Input
                   PVOID pData,             // Output
                   DWORD dwLen,             // Input
                   PDWORD pLength,          // Output
                   DWORD dwMilliseconds);   // Input
	 */
	public static ReadBytes MPUSBReadInt(int handle, int len , int milliseconds) throws NativeException, IllegalAccessException {
    	Pointer pData = new	Pointer(new HeapMemoryBlock(len));
		//Pointer pData = new	Pointer(MemoryBlockFactory.createMemoryBlock(len));
    	LONG pLength = new LONG(40);
    	if(f_MPUSBReadInt == null) {
    		//seteo la funcion a invocar
        	f_MPUSBReadInt = new JNative(DLL_NAME, "MPUSBReadInt");
        	//seteo tipo de retorno (la dll devuelve un DWORD) 
    		f_MPUSBReadInt.setRetVal(Type.INT);
    	}	
    	//seteo los parametros de la funcion
    	f_MPUSBReadInt.setParameter(0, Type.INT, "" + handle);
    	f_MPUSBReadInt.setParameter(1, pData);
    	f_MPUSBReadInt.setParameter(2, Type.INT, "" + len);
    	f_MPUSBReadInt.setParameter(3, pLength.createPointer());
    	f_MPUSBReadInt.setParameter(4, Type.INT, "" +milliseconds);
    	//invoco la funcion
    	f_MPUSBReadInt.invoke();
    	byte[] readBytes = pData.getMemory();
    	pData.dispose();
    	ReadBytes ret=new ReadBytes(readBytes,
    					pLength.getValue(),
    					Integer.parseInt(f_MPUSBReadInt.getRetVal())); 
    	return ret;
    }
	/*
	 * wrapper de la funcion de la dll:
	 * BOOL MPUSBClose(HANDLE handle)
	 */
	public static int MPUSBClose(int handle) throws NativeException, IllegalAccessException {
    	if(f_MPUSBClose == null) {
    		//seteo la funcion a invocar
            f_MPUSBClose = new JNative(DLL_NAME, "MPUSBClose");
            //seteo tipo de retorno (la dll devuelve un BOOL que es de hecho un INT) 
    		f_MPUSBClose.setRetVal(Type.LONG);
    	}	
    	//seteo los parametros
    	f_MPUSBClose.setParameter(0, Type.INT, "" +handle);
    	//invoco la funcion
    	f_MPUSBClose.invoke();
        return new Integer(f_MPUSBClose.getRetVal()).intValue();
    }
    
}
